﻿using UnityEngine;
using System.Collections;

public class LVL1_Begin : StoryEvent
{
    protected Brick[] m_Bricks;
    private AudioSource m_AudioSource;

    public override void StartStory()
    {
        base.StartStory();
        GameManager.Instance.CanPlayMusic = false;
        m_AudioSource = GetComponent<AudioSource>();
        m_Bricks = GameObject.Find("Level/Level creator").GetComponentsInChildren<Brick>();
        foreach (Brick b in m_Bricks)
        {
            b.SwitchOff();
        }
        //Fade.Instance.InstantIn();
        StartCoroutine("C_Begin");
    }
    
    private IEnumerator C_Begin()
    {
        GameManager.Instance.PlayerCanMove = false;
        yield return new WaitForSeconds(1.5f);
        m_AudioSource.Play();
        foreach (Brick cube in m_Bricks)
        {
            cube.Illumin();
        }

        yield return new WaitForSeconds(5.5f);
        GameManager.Instance.PlayerCanMove = true;
        GameManager.Instance.CanPlayMusic = true;
        m_Finished = true;
    }
}